import java.text.*;
import java.util.*;
import java.awt.*;
import javax.swing.*;

public class GraphPanel extends JComponent {

	public DecimalFormat timeFormat = new DecimalFormat("#.###");
	public DecimalFormat powerFormat = new DecimalFormat("#.###");
	public DecimalFormat energyFormat = new DecimalFormat("#.###");

	int marginLeft = 32;
	int marginRight = 16;
	int marginTop = 32;
	int marginBottom = 32;

	Font titleFont = new Font("Arial", Font.BOLD, 18);
	Font labelFont = new Font("Arial", Font.PLAIN, 12);

	double[] x;
	double[] y;
	double minX, maxX, minY, maxY;
	double hbarPosition = 0;
	double vbarPosition = 0;
	boolean hbarVisible = false;
	boolean vbarVisible = false;
	String XLabel = "X axis";
	String YLabel = "Y axis";
	String Title = "Title";
	Stroke axisStroke = new BasicStroke(1);
	Stroke lineStroke = new BasicStroke(1);
	Stroke barStroke = new BasicStroke(1, BasicStroke.CAP_BUTT,BasicStroke.JOIN_BEVEL,
							0, new float[] {4}, 0);
	public GraphPanel()
	{
		setPreferredSize(new Dimension(100, 100));
	}

	public void paintComponent(Graphics g) 
	{
		super.paintComponent(g);

		Graphics2D g2d = (Graphics2D)g.create();

		Insets insets = getInsets();
		int currentWidth = getWidth() - insets.left - insets.right;
		int currentHeight = getHeight() - insets.top - insets.bottom;

		//g2d.setColor(Color.white);
		//g2d.fillRect(insets.left, insets.top, currentWidth, currentHeight);

		int x0 = insets.left + marginLeft;
		int y0 = insets.top + currentHeight - marginBottom;
		int w = currentWidth - marginLeft - marginLeft;
		int h = currentHeight - marginTop - marginBottom;

		g2d.setColor(Color.black);
		g2d.setFont(titleFont);
		g2d.drawString(Title, marginLeft, marginTop - 16);

		g2d.setFont(labelFont);
		g2d.drawString(XLabel, x0, y0 + 16);
		drawVerticalString(g2d, YLabel, x0 - 12, y0);

		g2d.setColor(Color.white);
		g2d.fillRect(x0, y0 - h, w, h);

		if (x != null) 
			drawGraph(g2d, x0, y0, w, h);
	}

	public void drawVerticalString(Graphics2D g2d, String text, int x, int y)
	{
		g2d.translate(x, y);
		g2d.rotate(-Math.PI/2.0);
		g2d.drawString(text, 0, 0);
		g2d.rotate(+Math.PI/2.0);
		g2d.translate(-x, -y);
	}

	public void keepDataBetweenX(double xmin, double xmax)
	{
		int n = x.length;
		double[] newx = new double[n];
		double[] newy = new double[n];
		int k = 0;
		for (int i = 0; i < n; i++)
		{
			if ((x[i] < xmin) || (x[i] > xmax))
				continue;
			newx[k] = x[i];
			newy[k] = y[i];
			k++;
		}
		setData(newx, newy, k);
	}

	public void setData(double[] xdata, double[] ydata)
	{
		int n = xdata.length;
		setData(xdata, ydata, n);
	}

	public void setData(double[] xdata, double[] ydata, int n)
	{
		x = new double[n];
		y = new double[n];

		minX = xdata[0];
		maxX = xdata[0];
		minY = ydata[0];
		maxY = ydata[0];

		for (int i = 0; i < n; i++)
		{
			x[i] = xdata[i];
			y[i] = ydata[i];
			if (x[i] > maxX) maxX = x[i];
			if (x[i] < minX) minX = x[i];
			if (y[i] > maxY) maxY = y[i];
			if (y[i] < minY) minY = y[i];
		}
	}

	public void setHbarPosition(double position)
	{
		hbarPosition = position;
	}

	public void setVbarPosition(double position)
	{
		vbarPosition = position;
	}

	public void setHbarVisible(boolean visible)
	{
		hbarVisible = visible;
	}

	public void setVbarVisible(boolean visible)
	{
		vbarVisible = visible;
	}

	private void drawGraph(Graphics2D g2d, int x0, int y0, int w, int h)
	{
		if ((hbarVisible) && (hbarPosition >= minY) && (hbarPosition <= maxY))
		{
			g2d.setStroke(barStroke);
			g2d.setColor(Color.darkGray);
			int y = (int) ((hbarPosition - minY) / (maxY - minY) * h);
			g2d.drawLine(x0, y0 - y, x0 + w, y0 - y);			
		}
		if ((vbarVisible) && (vbarPosition >= minX) && (vbarPosition <= maxX))
		{
			g2d.setStroke(barStroke);
			g2d.setColor(Color.darkGray);
			int x = (int) ((vbarPosition - minX) / (maxX - minX) * w);
			g2d.drawLine(x0 + x, y0, x0 + x, y0 - h);			
		}

		g2d.setColor(Color.black);
		g2d.setStroke(axisStroke);
		g2d.drawLine(x0, y0, x0 + w, y0);
		g2d.drawLine(x0, y0, x0, y0 - h);

		g2d.setStroke(lineStroke);
		for (int i = 1; i < x.length; i++)
		{
			int x1 = (int) ((x[i-1] - minX) / (maxX - minX) * w);
			int y1 = (int) ((y[i-1] - minY) / (maxY - minY) * h);
			int x2 = (int) ((x[i] - minX) / (maxX - minX) * w);
			int y2 = (int) ((y[i] - minY) / (maxY - minY) * h);
			g2d.drawLine(x0+x1, y0-y1, x0+x2, y0-y2);
		}
	}

}
