import java.awt.*;
import java.text.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;
import javax.swing.*;
import javax.swing.event.*;

public class MainWindow extends JFrame {

	static final int jobCount = 8;

	static final double minEnergy = 0.25;
	static final double maxEnergy = 10;

	final int[] defaultReleaseDates = {0, 1, 3};
	final Scheduler scheduler = new Scheduler();

	SchedulePanel schedulePanel;
	GraphPanel graphPanel1;
	GraphPanel graphPanel2;
	JSlider slider;

	ArrayList<Job> jobs;

	final JTextField[] releaseDate = new JTextField[jobCount];

	public MainWindow() {
		super("Getting the Best Response for your Erg");

		//setResizable(false);
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

		JPanel controlPanel = new JPanel(new BorderLayout());
		controlPanel.add(createInputPanel(), BorderLayout.CENTER);

		JPanel mainPanel = new JPanel(new GridLayout(2, 1));
		JPanel graphPanel = new JPanel(new GridLayout(1, 2));

		schedulePanel = new SchedulePanel();
		mainPanel.add(schedulePanel);
		mainPanel.add(graphPanel);

		graphPanel1 = new GraphPanel();
		graphPanel2 = new GraphPanel();
		graphPanel.add(graphPanel1);
		graphPanel.add(graphPanel2);

		Container content = getContentPane();
		content.add(controlPanel, BorderLayout.NORTH);
		content.add(mainPanel, BorderLayout.CENTER);

		pack();

		recalculate();
	}

	public void recalculate()
	{
		jobs = new ArrayList<Job>();
		for (int i = 0; i < jobCount; i++)
		{
			if (releaseDate[i].getText().length() == 0)
				continue;
			Job job = new Job(i+1);
			jobs.add(job);
			job.releaseDate = Double.parseDouble(releaseDate[i].getText());
		}

		scheduler.calculate(jobs);

		// copy scheduler data to graphs
		scheduler.graphEnergyLevels(graphPanel1);
		scheduler.graphCompletionDates(graphPanel2);
		graphPanel1.keepDataBetweenX(minEnergy*0.99, maxEnergy*1.01);
		graphPanel2.keepDataBetweenX(minEnergy*0.99, maxEnergy*1.01);

		sliderChanged();
	}

	public void sliderChanged()
	{
		double energyLevel = getEnergyLevel();
		scheduler.setEnergyLevel(jobs, energyLevel);
		schedulePanel.setSchedule(jobs, energyLevel);

		// update bars in graphs
		double sumC = 0;
		for (int i = 0; i < jobs.size(); i++)
			sumC += jobs.get(i).completionDate;

		double pn = jobs.get(jobs.size() - 1).power;

		graphPanel1.setVbarPosition(energyLevel);
		graphPanel1.setHbarPosition(pn);

		graphPanel2.setVbarPosition(energyLevel);
		graphPanel2.setHbarPosition(sumC);
		graphPanel1.setVbarVisible(true);
		graphPanel1.setHbarVisible(true);
		graphPanel2.setVbarVisible(true);
		graphPanel2.setHbarVisible(true);

		graphPanel1.repaint();
		graphPanel2.repaint();
	}

	double getEnergyLevel()
	{
		return slider.getValue() / 100.0;
	}

	public JPanel createInputPanel()
	{
		MyPanel panel = new MyPanel();

		for (int i = 0; i < jobCount; i++) 
			releaseDate[i] = panel.addInputField("Release date job " + (i+1), 
				(i < defaultReleaseDates.length ? Integer.toString(defaultReleaseDates[i]) : ""));


		JButton calcButton = new JButton("Calculate");
		calcButton.addActionListener(new ActionListener() { public void actionPerformed(ActionEvent e) { recalculate(); } });
		panel.add(calcButton);
		for (int i = 0; i < 3; i++)
			panel.add(new JLabel(""));

		JLabel sliderLabel = new JLabel("Energy level:");
		slider = new JSlider(JSlider.HORIZONTAL, (int) (minEnergy * 100), 
							(int) (maxEnergy * 100), (int) (maxEnergy * 100));

		panel.add(sliderLabel);
		panel.add(slider);

		for (int i = 0; i < 2; i++)
			panel.add(new JLabel(""));

		// prepare labels for slider
		slider.addChangeListener(new ChangeListener() { 
			public void stateChanged(ChangeEvent e) 
			{ 
				sliderChanged(); 
			} } );



		return panel;
	}

}
