import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;
import javax.swing.*;

public class MyPanel extends JPanel {

	int row = 0;
	int col = 0;
	int nColumns = 4;

	GridBagLayout layout;

	public MyPanel()
	{
		super();

		layout = new GridBagLayout();
		setLayout(layout);
	}

	public JTextField addInputField(String caption, String defaultValue)
	{
		JLabel label = new JLabel(caption + ":");
		JTextField textField = new JTextField(defaultValue, 10);
		add(label);
		add(textField);
		return textField;
	}

	public Component add(Component comp)
	{
		GridBagConstraints c = new GridBagConstraints();
		c.fill = GridBagConstraints.HORIZONTAL;
		c.gridy = row;
		c.gridx = col;
		c.weightx = 0.5;
		c.weighty = 0.5;
		c.insets = new Insets(2,2,2,2);

		add(comp, c);

		col++;
		if (col >= nColumns)
		{
			col = 0;
			row++;
		}

		return comp;
	}

}
