import java.text.*;
import java.util.*;
import java.awt.*;
import javax.swing.*;

public class SchedulePanel extends JComponent {

	public static DecimalFormat timeFormat = new DecimalFormat("#.###");
	public static DecimalFormat powerFormat = new DecimalFormat("#.###");
	public static DecimalFormat energyFormat = new DecimalFormat("#.###");

	Font titleFont = new Font("Arial", Font.BOLD, 18);
	Font labelFont = new Font("Arial", Font.PLAIN, 14);
	Font infoFont = new Font("Arial", Font.PLAIN, 13);

	private double energyLevel;
	ArrayList<Job> jobs = null;

	Color[] jobColors = {Color.red, Color.blue, Color.magenta, Color.orange, Color.pink};

	public SchedulePanel()
	{
		setPreferredSize(new Dimension(2000, 2000));
	}

	public void paintComponent(Graphics g) 
	{
		super.paintComponent(g);

		Graphics2D g2d = (Graphics2D)g.create();

		Insets insets = getInsets();
		int currentWidth = getWidth() - insets.left - insets.right;
		int currentHeight = getHeight() - insets.top - insets.bottom;

		//g2d.setColor(Color.white);
		//g2d.fillRect(insets.left, insets.top, currentWidth, currentHeight);

		g2d.setColor(Color.black);
		g2d.setFont(titleFont);
		g2d.drawString("Optimal schedule", 32, 16);
		g2d.setFont(labelFont);
		g2d.drawString("Energy level = " + energyLevel, 32, 36);

		if (jobs == null) 
			return;

		g2d.setFont(infoFont);
		double sumC = 0;
		for (int i = 0; i < jobs.size(); i++)
		{
			Job job = jobs.get(i);
			g2d.setColor(jobColors[i % jobColors.length]);
			g2d.fillRect( timeX(job.startDate), 70, timeX(job.completionDate) - timeX(job.startDate), 60);
			g2d.setColor(Color.black);

			int x = timeX(job.startDate);
			int y = 160, w = 14;
			g2d.drawString("rel:" + timeFormat.format(job.releaseDate), x, y);
			g2d.drawString("start:" + timeFormat.format(job.startDate), x, y + w);
			g2d.drawString("compl:" + timeFormat.format(job.completionDate), x, y + 2*w);

			g2d.drawString("power:" + powerFormat.format(job.power), x, y + 3*w);
			g2d.drawString("energy:" + energyFormat.format(job.energyUse), x, y + 4*w);
			if (job.config.length() > 0)
				g2d.drawString("config:\"" + job.config + "\"", x, y + 5*w);

			sumC += job.completionDate;
		}

		g2d.setColor(Color.black);
		g2d.setFont(labelFont);
		g2d.drawString("Total completion time = " + timeFormat.format(sumC), 32, 54);
	}

	private int timeX(double t)
	{
		return 32 + (int) (t * 100);
	}

	public void setSchedule(ArrayList<Job> jobs, double energyLevel)
	{
		this.energyLevel = energyLevel;
		this.jobs = jobs;
		repaint();
	}
}
